<?php

use Elementor\Scheme_Typography;
use Elementor\Scheme_Color;
use Elementor\Group_Control_Border;
use Elementor\Group_Control_Typography;

if (!defined('ABSPATH')) {
    exit; // Exit if accessed directly.
}

use Elementor\Controls_Manager;

class OSF_Elementor_Video_Popup extends Elementor\Widget_Base {

    public function get_name() {
        return 'opal-video-popup';
    }

    public function get_title() {
        return __('Opal Video', 'givelove-core');
    }

    public function get_categories() {
        return array('opal-addons');
    }

    public function get_icon() {
        return 'eicon-youtube';
    }

    public function get_script_depends() {
        return ['magnific-popup', 'tweenmax'];
    }

    public function get_style_depends() {
        return ['magnific-popup'];
    }


    protected function _register_controls() {
        $this->start_controls_section(
            'section_videos',
            [
                'label' => __('General', 'givelove-core'),
                'tab'   => Controls_Manager::TAB_CONTENT,
            ]
        );
        $this->add_control(
            'video_type',
            [
                'label'        => __('Style', 'givelove-core'),
                'type'         => Controls_Manager::SELECT,
                'default'      => 'magnific',
                'options'      => [
                    'magnific' => __('Style 1', 'givelove-core'),
                    'snippet'  => __('Style 2', 'givelove-core'),
                ],
                'prefix_class' => 'elementor-opal-video-view-',
                'separator'    => 'before',
                'frontend_available' => true,
            ]
        );
        $this->add_control(
            'video_link',
            [
                'label'       => __('Link to', 'givelove-core'),
                'type'        => Controls_Manager::TEXT,
                'description' => __('Support video from Youtube and Vimeo', 'givelove-core'),
                'placeholder' => __('https://your-link.com', 'givelove-core'),
                'default'     => __('https://youtu.be/dQw4w9WgXcQ', 'givelove-core'),
            ]
        );
        $this->end_controls_section();
    }

    protected function render() {
        $settings = $this->get_settings_for_display();
        $this->add_render_attribute('wrapper', 'class', 'opal-video-popup-wrapper');

        $isSnippet = ($settings['video_type'] != 'magnific');
        $this->add_render_attribute('button', 'class', 'play-button');
        $tag = 'div';
        if (!$isSnippet) {
            $this->add_render_attribute('button', 'role', 'button');
            $this->add_render_attribute('button', 'href', esc_url($settings['video_link']));
            $this->add_render_attribute('button', 'data-effect', 'mfp-zoom-in');
            $tag = 'a';
        }
        ?>
        <div <?php echo $this->get_render_attribute_string('wrapper'); ?>>
            <div class="play-backdrop"></div>
            <<?php echo $tag ?> <?php echo $this->get_render_attribute_string('button') ?>>
                <svg class="play-circles" viewBox="0 0 152 152">
                    <circle class="play-circle-01" fill="none" stroke="#fff" stroke-width="3" stroke-dasharray="343 343"
                            cx="76" cy="76" r="72.7"/>
                    <circle class="play-circle-02" fill="none" stroke="#fff" stroke-width="3" stroke-dasharray="309 309"
                            cx="76" cy="76" r="65.5"/>
                </svg>
        <i class="fa fa-play"></i>
                <div class="play-perspective">
                    <span class="play-close"></span>
                    <div class="play-triangle">
                        <div class="play-video">
                            <?php echo $isSnippet ? wp_oembed_get($settings['video_link']) : '<div style="width: 600px; height: 338px;"></div>'; ?>
                        </div>
                    </div>
                </div>
            </<?php echo $tag ?> >
        </div>
        <?php
    }

}

$widgets_manager->register_widget_type(new OSF_Elementor_Video_Popup());