<article id="post-<?php the_ID(); ?>" <?php post_class(); ?>>
    <div class="post-inner">

	    <?php if ('' !== get_the_post_thumbnail() && !is_single()) : ?>
            <div class="post-thumbnail">
                <a href="<?php the_permalink(); ?>">
				    <?php the_post_thumbnail('givelove-featured-image-full'); ?>
                </a>
            </div><!-- .post-thumbnail -->
	    <?php endif; ?>

        <header class="entry-header">
            <?php if ('post' === get_post_type()) : ?>
                <div class="entry-meta">
                    <?php givelove_posted_on(); ?>
                </div><!-- .entry-meta -->
            <?php endif; ?>

            <?php

            if (is_single()) {
                the_title('<h1 class="entry-title">', '</h1>');
            } elseif (is_front_page() && is_home()) {
                the_title('<h3 class="entry-title"><a href="' . esc_url(get_permalink()) . '" rel="bookmark">', '</a></h3>');
            } else {
                the_title('<h2 class="entry-title"><a href="' . esc_url(get_permalink()) . '" rel="bookmark">', '</a></h2>');
            }
            ?>

            <?php if (is_single()) : ?>
                <div class="entry-avatar">
                    <?php echo get_avatar(get_the_author_meta('email'), 38) ?>
                    <a href="<?php echo get_author_posts_url(get_the_author_meta('ID')) ?>"><?php the_author() ?></a>
                </div><!-- .entry-meta -->
            <?php endif; ?>

        </header><!-- .entry-header -->

        <div class="entry-content">

            <?php
            if (is_single() || '' === get_the_post_thumbnail()) {

                // Only show content if is a single post, or if there's no featured image.
                /* translators: %s: Name of current post */
                the_content(sprintf(
                    __('Read more<span class="screen-reader-text"> "%s"</span>', 'givelove'),
                    get_the_title()
                ));


                wp_link_pages(array(
                    'before' => '<div class="page-links">' . esc_html__('Pages:', 'givelove'),
                    'after' => '</div>',
                    'link_before' => '<span class="page-number">',
                    'link_after' => '</span>',
                ));

            };
            ?>

        </div><!-- .entry-content -->
        <?php if (is_single()) : ?>
            <div class="author-post">
                <div class="author-post-header text-center">
                        <?php echo get_avatar(get_the_author_meta('email'), 70) ?>
                    <span>About the author</span>
                    <h4 class="author-title">William Smith</h4>
                </div>
                <div class="description">
                    Lorem ipsum dolor sit amet, consectetur adipisicing elit, sed do eiusmod tempor incididunt ut labore et dolore magna aliqua. Ut enim ad minim veniam,
                    quis nostrud exercitation ullamco laboris nisi ut aliquip ex ea commodo consequat.
                </div>
            </div>
        <?php endif; ?>
        <?php
        if (is_single()) {
            givelove_entry_footer();
            givelove_social_share();
        }
        ?>
    </div>

</article><!-- #post-## -->
